import os
import shutil
from PIL import Image

Image.MAX_IMAGE_PIXELS = None

# Static paths for folders
FOLDER_A = r"D:\woman dataset\1536x1536"  # Cropped images dataset
FOLDER_B = r"D:\woman dataset\final_raw_dataset"  # Raw images dataset
FOLDER_C = r"G:\woman dataset\low_res_images"  # Raw low res images moved
FOLDER_D = r"G:\woman dataset\1536x1536\low_res_images"  # Cropped low res images moved

# Static dimensions
MIN_WIDTH = 1536
MIN_HEIGHT = 1536

# Create folders C and D if they don't exist
os.makedirs(FOLDER_C, exist_ok=True)
os.makedirs(FOLDER_D, exist_ok=True)

# Get all image files in folder A
image_files = [f for f in os.listdir(FOLDER_A) if f.endswith(('.png', '.jpg', '.jpeg', '.bmp', '.gif'))]
total_files = len(image_files)
files_processed = 0
files_moved = 0

# Processing images in folder A
for filename in image_files:
    image_path_a = os.path.join(FOLDER_A, filename)
    image_path_b = os.path.join(FOLDER_B, filename)

    # Check if same file exists in folder B
    if os.path.exists(image_path_b):
        # Check image dimensions
        with Image.open(image_path_a) as img:
            width, height = img.size

        if width < MIN_WIDTH or height < MIN_HEIGHT:
            # Move image from folder B to folder C
            shutil.move(image_path_b, FOLDER_C)

            # Move image from folder A to folder D
            shutil.move(image_path_a, FOLDER_D)
            files_moved += 1

    files_processed += 1
    print(f"Scanning folder: {files_processed}/{total_files} processed, {total_files - files_processed} left, {files_moved} moved")

print("Processing complete.")
