import json
import os

# Define input and output file paths
video_file_path = 'MQT/MQT_videoname.txt'
prompt_file_path = 'MQT/MQT_prompt.txt'
mos_file_path = 'MQT/MQT_mos.txt'
output_file_path = 'MQT/output.jsonl' # Define the output file name

# --- Optional: Create output directory if it doesn't exist ---
output_dir = os.path.dirname(output_file_path)
if output_dir and not os.path.exists(output_dir):
    try:
        os.makedirs(output_dir)
        print(f"Created output directory: {output_dir}")
    except OSError as e:
        print(f"Error creating directory {output_dir}: {e}")
        exit(1)
# --- End Optional ---

try:
    with open(video_file_path, 'r', encoding='utf-8') as f_video, \
         open(prompt_file_path, 'r', encoding='utf-8') as f_prompt, \
         open(mos_file_path, 'r', encoding='utf-8') as f_mos, \
         open(output_file_path, 'w', encoding='utf-8') as outfile:

        line_num = 0
        processed_count = 0
        skipped_count = 0

        # Use zip to read corresponding lines from all files simultaneously
        for video_line, prompt_line, mos_line in zip(f_video, f_prompt, f_mos):
            line_num += 1
            try:
                # Clean up lines
                video_name = video_line.strip()
                prompt_text = prompt_line.strip()
                mos_score_str = mos_line.strip()

                # Basic validation: skip if any line content is empty
                if not video_name or not prompt_text or not mos_score_str:
                    print(f"Warning: Skipping line {line_num} due to empty field(s).")
                    skipped_count += 1
                    continue

                # Convert MOS score to float
                mos_score = float(mos_score_str)

                # Construct the full video path as per the example structure's prefix
                full_video_path = f"Videos300/Allegro/{video_name}"

                # Construct the JSON data structure for the current line
                data = {
                    "video": full_video_path,
                    "mos": mos_score,
                    "conversations": [
                        {
                            "from": "human",
                            "value": f"How would you rate the correspondence of this video and its prompt? prompt: {prompt_text}" # Fixed human prompt
                        },
                        {
                            "from": "gpt",
                            "value":"The correspondence of the video and its prompt is good." # Use the prompt from MQT_prompt.txt
                        }
                    ]
                }

                # Write the JSON object as a single line to the output file
                outfile.write(json.dumps(data, ensure_ascii=False) + '\n')
                processed_count += 1

            except ValueError:
                print(f"Warning: Skipping line {line_num} due to invalid MOS score format: '{mos_score_str}'")
                skipped_count += 1
            except Exception as e:
                print(f"Warning: Skipping line {line_num} due to unexpected error: {e}")
                skipped_count += 1

        print("-" * 30)
        print(f"Processing complete.")
        print(f"Output saved to: {output_file_path}")
        print(f"Total lines read: {line_num}")
        print(f"Lines successfully processed: {processed_count}")
        print(f"Lines skipped due to errors/empty fields: {skipped_count}")
        print("-" * 30)


except FileNotFoundError as e:
    print(f"Error: Input file not found. Please ensure these files exist:")
    print(f"  - {video_file_path}")
    print(f"  - {prompt_file_path}")
    print(f"  - {mos_file_path}")
    print(f"Specific error: {e}")
except Exception as e:
    print(f"An unexpected error occurred during file opening or processing: {e}")
